#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Tubular worldMod01.fsh   by  ShnitzelKiller  
//https://www.shadertoy.com/view/wsySDV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define GRID 0.5
#define THICKNESS 0.05
#define FDIST 0.5

#define TOTAL_ITERS 100
#define RAYMARCH_EPS 0.001

#define OCCUPANCY 0.5

#define FOV 1.55

vec3 rainbow(float t) {
    return vec3(sin(t), cos(t), -sin(t)) * .5 + .5;
}

float traceCell(in vec3 ro, in vec3 rd) {
    vec3 dr = 1.0/rd;
    vec3 n = ro * dr;
    vec3 k = GRID * abs(dr);
    
    vec3 pout =  k - n;
    return min(pout.x, min(pout.y, pout.z));
}

float noise(in vec3 P)
{
    //  https://github.com/BrianSharpe/Wombat/blob/master/Value3D.glsl

    // establish our grid cell and unit position
    vec3 Pi = floor(P);
    vec3 Pf = P - Pi;
    vec3 Pf_min1 = Pf - 1.0;

    // clamp the domain
    Pi.xyz = Pi.xyz - floor(Pi.xyz * ( 1.0 / 69.0 )) * 69.0;
    vec3 Pi_inc1 = step( Pi, vec3( 69.0 - 1.5 ) ) * ( Pi + 1.0 );

    // calculate the hash
    vec4 Pt = vec4( Pi.xy, Pi_inc1.xy ) + vec2( 50.0, 161.0 ).xyxy;
    Pt *= Pt;
    Pt = Pt.xzxz * Pt.yyww;
    vec2 hash_mod = vec2( 1.0 / ( 635.298681 + vec2( Pi.z, Pi_inc1.z ) * 48.500388 ) );
    vec4 hash_lowz = fract( Pt * hash_mod.xxxx );
    vec4 hash_highz = fract( Pt * hash_mod.yyyy );

    //	blend the results and return
    vec3 blend = Pf * Pf * Pf * (Pf * (Pf * 6.0 - 15.0) + 10.0);
    vec4 res0 = mix( hash_lowz, hash_highz, blend.z );
    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );
    return dot( res0, blend2.zxzx * blend2.wwyy );
}

vec3 cellmod(in vec3 ro) {
    return mod(ro, GRID) - GRID*0.5;
}

vec3 cellID(in vec3 ro) {
    return floor(ro/GRID);
}

float occupancy(in vec3 id) {
    return noise(id);
}

// LOD SDF: skip evaluating details if the current distance OR the distance to the exit is 
float longpipe(vec3 ro, float mindist, float bound) {
    float dist = length(ro.yz) - THICKNESS;
    if (dist < min(mindist, bound)) {
        // complex stuff
        dist += 0.005*GRID*(cos(ro.x*20. * 3.14159)+1.);
    } 
    // bounding volume
    return dist;
}

float torus(vec3 ro) {
    float xydist = length(ro.xy) - 0.5 * GRID;
    return length(vec2(ro.z, xydist))-THICKNESS;
}

vec2 march(in vec3 ro, in vec3 rd) {
    vec3 id = cellID(ro);
    vec3 dr = GRID/rd;
    vec3 rs = sign(rd);
    vec3 tr = (0.5 * rs - cellmod(ro)/GRID) * dr; // exiting t
    vec3 t = vec3(0.); // current t
    int i;
    vec2 disp = vec2(1., 0.);
    for (i=0; i<TOTAL_ITERS; i++) {
        // DDA traversal
        if (occupancy(id) > OCCUPANCY) {
            // check neighbors
            vec3 n_pos = step(OCCUPANCY, vec3(occupancy(id+disp.xyy),
                              				  occupancy(id+disp.yxy),
                              				  occupancy(id+disp.yyx)));
            vec3 n_neg = step(OCCUPANCY, vec3(occupancy(id-disp.xyy),
                              				  occupancy(id-disp.yxy),
                              				  occupancy(id-disp.yyx)));
            vec3 n_axes = n_pos + n_neg;
            vec3 diff_axes = n_pos - n_neg;
            float total = n_axes.x + n_axes.y + n_axes.z;
            if (total > 0.5) {
            	
                
                // raymarching
                float t0 = min(t.x, min(t.y, t.z));
                float maxdist = min(tr.x, min(tr.y, tr.z)) - t0;
                vec3 ro0 = ro + t0 * rd - (id+0.5) * GRID;
                float tt = 0.;
                for (; i<TOTAL_ITERS; i++) {
                    vec3 pos = ro0 + tt * rd;
                    float dist = 1e6;
                    float bound = maxdist - tt;
                    if (n_axes.x > 1.5) {
                        dist = min(dist, longpipe(pos, dist, bound));
                    }
                    if (n_axes.y > 1.5) {
                        dist = min(dist, longpipe(pos.yzx, dist, bound));
                    }
                    if (n_axes.z > 1.5) {
                        dist = min(dist, longpipe(pos.zxy, dist, bound));
                    } 
                    for (int j=0; j<2; j++) {
                        if (abs(n_axes[j]-1.)<0.5) {
                            for (int k=j+1; k<3; k++) {
                                if (abs(n_axes[k]-1.)<0.5) {
                                    vec3 u = vec3(0.);
                                    u[j] = diff_axes[j];
                                    vec3 v = vec3(0.);
                                    v[k] = diff_axes[k];
                                    vec3 w = cross(u, v);
                                    mat3 rot = mat3(u, v, w);
                                    mat3 rotT = transpose(rot);
                                    vec3 pos_local = rotT * (pos -(v + u) * 0.5*GRID);
                                    dist = min(dist, torus(pos_local));
                                }
                            }
                        }
                    }
                    
                    tt += dist;
                    if (abs(dist) < RAYMARCH_EPS) {
                        return vec2(tt + t0, i);
                    }
                    if (tt > maxdist || tt < 0.) {
                        break;
                    }
                }
            }
        }
        t = tr;
        vec3 n = step(tr.xyz, tr.zxy) * step(tr.xyz, tr.yzx) * rs;
        tr += dr * n;
        id += n;
    }
    return vec2(min(t.x, min(t.y, t.z)), i);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (fragCoord - iResolution.xy * 0.5)/iResolution.x * FOV;
	vec3 eye = vec3(2.*iTime, 0.1, 0.1);
    vec3 w = normalize(vec3(1., sin(.5*iTime), cos(iTime*.2)));
    vec3 u = normalize(cross(w, vec3(0., 0., 1.)));
    vec3 v = cross(u, w);
    vec2 c = cos(uv);
    vec2 s = sin(uv);
    vec3 rd = normalize(s.x * c.y * u + s.y * v + c.x * c.y * w);
    
    vec2 t = march(eye, rd);
    
    fragColor = vec4(pow(rainbow(t.x/2.+1.5) * vec3(1.-t.y/100.), vec3(0.75)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

